<?php
/*
// JoomlaWorks "Frontpage Slideshow" Component for Joomla! 1.5.x - Version 2.4
// Copyright (c) 2006 - 2010 JoomlaWorks Ltd. All rights reserved.
// This code cannot be redistributed without permission from JoomlaWorks.
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: February 2nd, 2010***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// hide default Joomla! errors
error_reporting(0);

jimport('joomla.installer.installer');
$db = & JFactory::getDBO();
$status = new JObject();
$status->modules = array();
$status->plugins = array();
$src = $this->parent->getPath('source');

$modules = &$this->manifest->getElementByPath('modules');
if (is_a($modules, 'JSimpleXMLElement') && count($modules->children())) {
	foreach ($modules->children() as $module) {
		$mname = $module->attributes('module');
		$client = $module->attributes('client');
		if(is_null($client)) $client = 'site';
		($client=='administrator')? $path=$src.DS.'administrator'.DS.'modules'.DS.$mname: $path = $src.DS.'modules'.DS.$mname;
		$installer = new JInstaller;
		$result = $installer->install($path);
		$status->modules[] = array('name'=>$mname,'client'=>$client, 'result'=>$result);
	}
}

$plugins = &$this->manifest->getElementByPath('plugins');
if (is_a($plugins, 'JSimpleXMLElement') && count($plugins->children())) {
	foreach ($plugins->children() as $plugin) {
		$pname = $plugin->attributes('plugin');
		$pgroup = $plugin->attributes('group');
		$path = $src.DS.'plugins'.DS.$pgroup;
		$installer = new JInstaller;
		$result = $installer->install($path);
		$status->plugins[] = array('name'=>$pname,'group'=>$pgroup, 'result'=>$result);

		$query = "UPDATE #__plugins SET published=1 WHERE element='{$pname}' AND folder='{$pgroup}'";
		$db->setQuery($query);
		$db->query();
	}
}

if (JFolder::exists(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_joomfish'.DS.'contentelements')){
	$elements = &$this->manifest->getElementByPath('joomfish');
	if (is_a($elements, 'JSimpleXMLElement') && count($elements->children())) {
		foreach ($elements->children() as $element) {
			JFile::copy($src.DS.'administrator'.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.$element->data(),JPATH_ADMINISTRATOR.DS.'components'.DS.'com_joomfish'.DS.'contentelements'.DS.$element->data());
		}

	}
}
else {
	$mainframe = &JFactory::getApplication();
	$mainframe->enqueueMessage(JText::_('Notice: Content elements for Joom!Fish were not copied to the related folder, because Joom!Fish was not found on your system.'));
}

// Configuration file
if(!JFile::exists(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_fpss'.DS.'configuration.php')){
	$buffer = "
<?php
class FPSSConfig {
	var \$editor = '1';
	var \$articlelist = '1';
	var \$septhumb = '0';
	var \$show_width = '0';
	var \$show_quality = '0';
	var \$basepath = 'images/stories';
}
?>
";
	JFile::write(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_fpss'.DS.'configuration.php',trim($buffer));
}

// Sample data
$query = "SELECT COUNT(*) FROM #__fpss_slides";
$db->setQuery($query);
$numOfSlides=$db->loadResult();

$query = "SELECT COUNT(*) FROM #__fpss_categories";
$db->setQuery($query);
$numOfCategories=$db->loadResult();

if($numOfSlides==0 AND $numOfCategories==0){
	$query = "INSERT INTO `#__fpss_categories` (`id`, `name`, `width`, `quality`, `width_thumb`, `quality_thumb`, `published`) VALUES (1, 'Demo category', 400, 80, 100, 75, 1)";
	$db->setQuery($query);
	$db->query();

	$query = "INSERT INTO `#__fpss_slides` (`id`, `catid`, `name`, `path`, `path_type`, `thumb`, `state`, `publish_up`, `publish_down`, `itemlink`, `menulink`, `target`, `customlink`, `nolink`, `ctext`, `plaintext`, `registers`, `showtitle`, `showseccat`, `showcustomtext`, `showplaintext`, `showreadmore`, `ordering`) VALUES
	(2, 1, 'Slide linked to menu item', 'components/com_fpss/images/2007_transformers_014_1.jpg', '1', '', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 34, 0, '', 0, 'This slide is linked to a Joomla! menu item. Click on it and you''ll get redirected to the article &quot;What''s New In 1.5?&quot;.', 'Image taken from the movie \"Transformers\"', 0, 1, 1, 1, 1, 1, 4),
	(3, 1, 'Slide linked to content item', 'components/com_fpss/images/the_kingdom_20070820114258369.jpg', '1', '', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 19, 0, 1, '', 0, 'This slide is linked to a regular URL. If you click on it you''ll get redirected to the main JoomlaWorks website. This option is really helpful for example when you want to use Frontpage Slideshow with VirtueMart to showcase your products.', 'Image taken from the movie \"The Kingdom\"', 0, 1, 1, 1, 1, 1, 3),
	(4, 1, 'Frontpage Slideshow is Search Engine Friendly!', 'components/com_fpss/images/TVD_TR_02183_2.jpg', '1', '', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 'http://www.frontpageslideshow.net/content/view/14/37/', 0, '<p>Unlike Flash based slideshows, <strong>Frontpage Slideshow</strong> uses unobtrusive javascript and some CSS wizardry only. The content of the slides is laid out as html code, which means it can be \"read\" by search engines. The <strong>proper usage</strong> (and order) of h1, h2, p (and more) tags will make sure <strong>Google</strong> (or any other search engine) regularly \"scans\" your latest/featured items. <strong>This is something Flash based solutions just can''t beat! ;)</strong></p>', 'Image taken from the \"Invaders\"', 0, 1, 0, 1, 1, 1, 2),
	(5, 1, 'Frontpage Slideshow', 'components/com_fpss/images/ao4.jpg', '1', '', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 'http://www.frontpageslideshow.net/content/view/12/37/', 0, 'The \"<strong>Frontpage SlideShow</strong>\" Component/Module pack is the most eye-catching way to display your featured articles, stories or even products in your Joomla! website, like Time.com, Joost.com or Yahoo! Movies do. \"<strong>Frontpage SlideShow</strong>\" creates an uber-cool slideshow with text snippets laying on top of images. These \"slides\" are being rotated one after the other with a nice fade effect. The slideshow features navigation and play/pause buttons, so the visitor has complete control over the slideshow''s \"playback\"! And best of all, Frontpage Slideshow can be skinned!', 'Image taken from the movie \"Shoot ''em up\"', 0, 1, 1, 1, 1, 1, 1)
	";
	$db->setQuery($query);
	$db->query();
}

?>

<?php $rows = 0;?>
<img src="components/com_fpss/images/fpss_logo_460x60.png" width="460" height="60" alt="Frontpage Slideshow" align="right" />
<h2><?php echo JText::_('Frontpage Slideshow Installation Status'); ?></h2>
<table class="adminlist">
	<thead>
		<tr>
			<th class="title" colspan="2"><?php echo JText::_('Extension'); ?></th>
			<th width="30%"><?php echo JText::_('Status'); ?></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="3"></td>
		</tr>
	</tfoot>
	<tbody>
		<tr class="row0">
			<td class="key" colspan="2"><?php echo JText::_('Component'); ?></td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
		<?php if (count($status->modules)) : ?>
		<tr>
			<th><?php echo JText::_('Module'); ?></th>
			<th><?php echo JText::_('Client'); ?></th>
			<th></th>
		</tr>
		<?php foreach ($status->modules as $module) : ?>
		<tr class="row<?php echo (++ $rows % 2); ?>">
			<td class="key"><?php echo $module['name']; ?></td>
			<td class="key"><?php echo ucfirst($module['client']); ?></td>
			<td><strong><?php echo ($module['result'])?JText::_('Installed'):JText::_('Not installed'); ?></strong></td>
		</tr>
		<?php endforeach;?>
		<?php endif;?>
		<?php if (count($status->plugins)) : ?>
		<tr>
			<th><?php echo JText::_('Plugin'); ?></th>
			<th><?php echo JText::_('Group'); ?></th>
			<th></th>
		</tr>
		<?php foreach ($status->plugins as $plugin) : ?>
		<tr class="row<?php echo (++ $rows % 2); ?>">
			<td class="key"><?php echo ucfirst($plugin['name']); ?></td>
			<td class="key"><?php echo ucfirst($plugin['group']); ?></td>
			<td><strong><?php echo ($plugin['result'])?JText::_('Installed'):JText::_('Not installed'); ?></strong></td>
		</tr>
		<?php endforeach; ?>
		<?php endif; ?>
	</tbody>
</table>
