<?php
/*
// JoomlaWorks "Frontpage Slideshow" Module for Joomla! 1.5.x - Version 2.4
// Copyright (c) 2006 - 2010 JoomlaWorks Ltd. All rights reserved.
// This code cannot be redistributed without permission from JoomlaWorks.
// More info at http://www.joomlaworks.gr
// Designed and developed by the JoomlaWorks team
// ***Last update: February 2nd, 2010***
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// JoomlaWorks reference parameters
$mod_name               = "mod_fpss";
$mod_copyrights_start   = "\n\n<!-- JoomlaWorks \"Frontpage Slideshow\" (v2.4) starts here -->\n";
$mod_copyrights_end     = "\n<!-- JoomlaWorks \"Frontpage Slideshow\" (v2.4) ends here -->\n\n";

// API
jimport('joomla.filesystem.file');
jimport('joomla.utilities.date');
$mainframe	= &JFactory::getApplication();
$document 	= &JFactory::getDocument();
$db 				= &JFactory::getDBO();
$user 			= &JFactory::getUser();
$aid 				= (int) $user->get('aid',0);
$menu				= &JSite::getMenu();
$nullDate		= $db->getNullDate();
$date 			= new JDate();
$now 				= $date->toMySQL();

// Assign paths
$sitePath 	= JPATH_SITE;
$siteUrl  	= substr(JURI::root(),0,-1);

// Module parameters
$moduleclass_sfx 							= $params->get('moduleclass_sfx','');
$fpssCategory 								= (int) $params->get('fpssCategory',1);
$fpssTemplate 								= $params->get('fpssTemplate','Movies');
$fpssEngine 									= $params->get('fpssEngine','mootools');
$fpssJquery										= $params->get('fpssJquery','1.2.6');
$width 												= (int) $params->get('width',500);
$height 											= (int) $params->get('height',308);
$sidebarWidth 								= (int) $params->get('sidebarWidth',200);
$hideNavigation 							= (int) $params->get('hideNavigation',0);
$delay 												= (int) $params->get('delay',6000);
$transition 									= (int) $params->get('transition',1000);
$loadingTime 									= (int) $params->get('loadingTime',800);
$autoStart 										= ($params->get('autoStart',1)) ? 'true' : 'false';
$rotateAction 								= $params->get('rotateAction','click');
$mootoolsTextTransition 			= ($params->get('mootoolsTextTransition',0)) ? 'true' : 'false';
$mootoolsTextTransitionTime 	= (int) $params->get('mootoolsTextTransitionTime',1000);
$fpssOrdering 								= (int) $params->get('fpssOrdering',1);
$fpssSlideLimit 							= (int) $params->get('fpssSlideLimit');
$fpssSlideTitle								= $params->get('fpssSlideTitle','');
$fpssSlideSec     						= $params->get('fpssSlideSec','');
$fpssSlideCat     						= $params->get('fpssSlideCat','');
$fpssSlideSecCatSep 					= $params->get('fpssSlideSecCatSep','>>');
$fpssSlideText 								= $params->get('fpssSlideText','');
$fpssSlideTextWordLimit 			= (int) $params->get('fpssSlideTextWordLimit');
$fpssSlideTagline  						= $params->get('fpssSlideTagline','');
$fpssSlideReadMore   					= $params->get('fpssSlideReadMore','');
$fpssSlideLinksDisable				= (int) $params->get('fpssSlideLinksDisable',0);
// Module parameters (advanced)
$debugMode										= $params->get('debugMode',1);
if($debugMode==0) error_reporting(0); // Turn off all error reporting

// Hide the navigation bar if requested
if($hideNavigation){
	$sidebarWidth = 0;
	$hideNavigationCSS = '#navi-outer {display:none;}';
} else {
	$hideNavigationCSS = '';
}

// Quick check for the component
if(!JFolder::exists(JPATH_SITE.DS.'components'.DS.'com_fpss')){
	JError::raiseWarning('', JText::_("You need to install the Frontpage Slideshow component as well!"));
	echo JText::_("You need to install the Frontpage Slideshow component as well!");
	return;
}

// Includes
require_once(dirname(__FILE__).DS.'helper.php');
require_once(JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');

// Get slideshow contents from the database
$comContentParams = &JComponentHelper::getParams( 'com_content' );
$access = (!$comContentParams->get('shownoauth')) ? "AND ( (articles.access <= ".$aid." AND cc.access <= ".$aid." AND s.access <= ".$aid.") OR (articles.access IS NULL AND cc.access IS NULL AND s.access IS NULL) )" : "";

$query = "
	SELECT slides.*, articles.title as title, articles.introtext as introtext, articles.catid AS catid, articles.sectionid as sectionid, cc.title AS categoryTitle, s.title AS sectionTitle,
	CASE WHEN CHAR_LENGTH(articles.alias) THEN CONCAT_WS(\":\", articles.id, articles.alias) ELSE articles.id END as slug,
	CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(\":\", cc.id, cc.alias) ELSE cc.id END as catslug
	FROM #__fpss_slides as slides
	LEFT JOIN #__fpss_categories AS categories ON categories.id = slides.catid
	LEFT JOIN #__content AS articles ON articles.id = slides.itemlink
	LEFT JOIN #__categories AS cc ON cc.id = articles.catid
	LEFT JOIN #__sections AS s ON s.id = articles.sectionid
	WHERE categories.published=1
	AND slides.state=1
	AND slides.registers <= {$aid}
	AND (slides.publish_up = '{$nullDate}' OR slides.publish_up <= '{$now}')
	AND (slides.publish_down = '{$nullDate}' OR slides.publish_down >= '{$now}')
	AND slides.catid={$fpssCategory}
	AND (articles.state=1 OR articles.state IS NULL)
	AND (articles.publish_up = '{$nullDate}' OR articles.publish_up <= '{$now}' OR articles.publish_up IS NULL)
	AND (articles.publish_down = '{$nullDate}' OR articles.publish_down >= '{$now}' OR articles.publish_down IS NULL)
	AND (cc.published=1 OR cc.published IS NULL)
	AND (s.published=1 OR s.published IS NULL)
	{$access}
	ORDER BY ordering
";
$db->setQuery($query);
$rows = $db->loadObjectList();

// Loop through the slideshow contents
foreach($rows as $count=>$row){

	// Perform slide limit
	if($fpssSlideLimit && $count>=$fpssSlideLimit) continue;
	
	// Use slide IDs for indexing the array
	$key = $row->id;

  // Compare display options between component and module
	$showName           = ($fpssSlideTitle=='') ? $row->showtitle : $fpssSlideTitle;
	$showSectionTitle   = ($fpssSlideSec=='') ? $row->showseccat : $fpssSlideSec;
	$showCategoryTitle  = ($fpssSlideCat=='') ? $row->showseccat : $fpssSlideCat;
	$showText       		= ($fpssSlideText=='') ? $row->showcustomtext : $fpssSlideText;
	$showTagline        = ($fpssSlideTagline=='') ? $row->showplaintext : $fpssSlideTagline;
	$showReadMore       = ($fpssSlideReadMore=='') ? $row->showreadmore : $fpssSlideReadMore;
	
	// Get menu data
	if($row->menulink) $menuItem = $menu->getItem($row->menulink);

	// Slide name
	if($row->itemlink && $row->title){
		$output[$key]->name = $row->title; //$row->name
	} elseif($row->menulink && $menuItem){
		$output[$key]->name = $menuItem->name; //$row->name
	} else {
		$output[$key]->name = $row->name;
	}
	if(!$showName) $output[$key]->name = '';
	
	// Slide link
	if($row->itemlink && $row->slug){
		$output[$key]->link = JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid));
	} elseif($row->menulink && $menuItem){
		$output[$key]->link = JRoute::_($menuItem->link.'&Itemid='.$menuItem->id);
	} elseif($row->customlink){
		$output[$key]->link = JFilterOutput::ampReplace($row->customlink);
	} else {
		$output[$key]->link = 'javascript:void(0);';
	}
	
	// Slide link target
	$output[$key]->target = ($row->target && $output[$key]->link != 'javascript:void(0);') ? ' target="_blank"' : '' ;
	
	// Slide text
	if($row->itemlink && $row->slug){
		if($row->ctext){
			$output[$key]->text = $row->ctext;
		} else {
			$output[$key]->text = $row->introtext; //$row->ctext
		}
	} else {
		$output[$key]->text = $row->ctext;
	}
	if(!$showText) $output[$key]->text = '';
	
	// Slide tagline
	if($showTagline) $output[$key]->tagline = strip_tags($row->plaintext); else $output[$key]->tagline = '';
	
	// Build the Section >> Category path if it exists
	if($row->itemlink && $row->slug && ($showSectionTitle || $showCategoryTitle)){
		if($showSectionTitle){
			$output[$key]->secCatPath = $row->sectionTitle;
			if($showCategoryTitle) $output[$key]->secCatPath .= ' '.$fpssSlideSecCatSep.' '.$row->categoryTitle;
		} else {
			if($showCategoryTitle) $output[$key]->secCatPath = $row->categoryTitle;
		}
	} else {
		$output[$key]->secCatPath = '';
	}
	
	// Slide image (main)
	$output[$key]->mainImage = $siteUrl.'/'.$row->path;

	// Slide image (thumb)
	if($row->thumb) $output[$key]->thumbImage = $siteUrl.'/'.$row->thumb; else $output[$key]->thumbImage = $siteUrl.'/'.$row->path;
	
	// Slide counter
	if(($count+1) < 10) $output[$key]->counter = "0".($count+1); else $output[$key]->counter = $count+1;

	// Slide rotate action
	if($rotateAction=='mouseover'){
		$output[$key]->rotateAction = ' onclick="parent.location=\''.$output[$key]->link.'\';return false;"';
	} else {
		$output[$key]->rotateAction = '';
	}

	// --------------- Content processing ---------------
	// Word limit on slide text
	if($fpssSlideTextWordLimit) $output[$key]->text = JWFrontpageSlideshowHelper::wordLimiter($output[$key]->text,$fpssSlideTextWordLimit);
	
	// Hide slide content completely if the each slide content element is hidden as well
	if(!$showName && !$showSectionTitle && !$showCategoryTitle && !$showText && !$showTagline && !$showReadMore){
		$output[$key]->content = false;
	} else {
		$output[$key]->content = true;
	}
	
	// Disable all slide links
	if($fpssSlideLinksDisable) $output[$key]->link = 'javascript:void(0);';
	
}

// Ordering
switch ($fpssOrdering) {
	case 1: break;
	case 2: krsort($output); 	break;
	case 3: ksort($output); 	break;
	case 4: asort($output); 	break;
	case 5: arsort($output); 	break;
	case 6: shuffle($output); break;
}

// Load FPSS head includes
//$fpssTemplatePath = $siteUrl.'/modules/mod_fpss/tmpl/'.$fpssTemplate;
$fpssTemplatePath = JWFrontpageSlideshowHelper::getTemplatePath($mod_name,$fpssTemplate);

if($mainframe->getCfg('caching')){
?>

	<?php echo $mod_copyrights_start; ?>
	<?php if($fpssEngine=='jquery' && $fpssJquery): ?>
	<!-- Load jQuery remotely -->
	<script type="text/javascript" src="http://www.google.com/jsapi"></script>
	<script type="text/javascript">google.load("jquery", "<?php echo $fpssJquery; ?>");</script>
	<?php endif; ?>
	<script type="text/javascript">
		//<![CDATA[
		document.write('\
		<style type="text/css" media="all">\
			@import "<?php echo $fpssTemplatePath; ?>/css/template_css.php?w=<?php echo $width; ?>&h=<?php echo $height; ?>&sw=<?php echo $sidebarWidth; ?>";\
			<?php echo $hideNavigationCSS; ?>\
		</style>\
		');
		//]]>
	</script>
	<!--[if lte IE 7]>
	<link rel="stylesheet" href="<?php echo $fpssTemplatePath; ?>/css/template_css_ie.css" type="text/css" />
	<![endif]-->
	<script type="text/javascript" src="<?php echo $siteUrl; ?>/modules/mod_fpss/includes/engines/<?php echo $fpssEngine; ?>-fpss-comp.js"></script>
	<script type="text/javascript">
		//<![CDATA[
		var fpssPlayText = "<?php echo JText::_('Play'); ?>";
		var fpssPauseText = "<?php echo JText::_('Pause'); ?>";
		var navTrigger = "<?php echo $rotateAction; ?>";
		var crossFadeDelay = <?php echo $delay; ?>;
		var crossFadeSpeed = <?php echo $transition; ?>;
		var fpssLoaderDelay = <?php echo $loadingTime; ?>;
		var autoslide = <?php echo $autoStart; ?>;
		var CTRtext_effect = <?php echo $mootoolsTextTransition; ?>;
		var CTRtransitionText = <?php echo $mootoolsTextTransitionTime; ?>;
		//]]>
	</script>
	<?php echo $mod_copyrights_end; ?>

<?php } else { ?>

	<?php
	$headIncludesNoCache = JHTML::_('behavior.mootools');
	
	if($fpssEngine=='jquery' && $fpssJquery){
	$headIncludesNoCache .= '
	<!-- Load jQuery remotely -->
	<script type="text/javascript" src="http://www.google.com/jsapi"></script>
	<script type="text/javascript">google.load("jquery", "'.$fpssJquery.'");</script>
	';
	}
	
	$headIncludesNoCache .= '
	<style type="text/css" media="all">
		<!--
		@import "'.$fpssTemplatePath.'/css/template_css.php?w='.$width.'&h='.$height.'&sw='.$sidebarWidth.'";
		'.$hideNavigationCSS.'
		//-->
	</style>
	<!--[if lte IE 7]>
	<link rel="stylesheet" href="'.$fpssTemplatePath.'/css/template_css_ie.css" type="text/css" />
	<![endif]-->
	<script type="text/javascript" src="'.$siteUrl.'/modules/mod_fpss/includes/engines/'.$fpssEngine.'-fpss-comp.js"></script>
	<script type="text/javascript">
		//<![CDATA[
		var fpssPlayText = "'.JText::_('Play').'";
		var fpssPauseText = "'.JText::_('Pause').'";
		var navTrigger = "'.$rotateAction.'";
		var crossFadeDelay = '.$delay.';
		var crossFadeSpeed = '.$transition.';
		var fpssLoaderDelay = '.$loadingTime.';
		var autoslide = '.$autoStart.';
		var CTRtext_effect = '.$mootoolsTextTransition.';
		var CTRtransitionText = '.$mootoolsTextTransitionTime.';
		//]]>
	</script>
	';

	$document->addCustomTag($mod_copyrights_start.$headIncludesNoCache.$mod_copyrights_end);

}

// Output content with template
echo $mod_copyrights_start;
require(JModuleHelper::getLayoutPath($mod_name,$fpssTemplate.DS.'default'));
echo JWFrontpageSlideshowHelper::setCrd();
echo $mod_copyrights_end;

// END
